package ru.yandex.ljinx.function;

import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;

import org.apache.http.Header;

import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.request.function.BinaryValue;
import ru.yandex.http.util.request.function.RequestFunction;
import ru.yandex.http.util.request.function.RequestFunctionValue;
import ru.yandex.io.DecodableByteArrayOutputStream;

public class RequestDataFunction<V extends LjinxFunctionContext>
    extends RequestDataFunctionBase<V>
    implements RequestFunction<V>
{
    public RequestDataFunction(final RequestFunction<V>[] args) {
        super(args);
    }

    @SuppressWarnings({"unchecked", "rawtypes"})
    public RequestDataFunction() {
        super((RequestFunction<V>[]) new RequestFunction[0]);
    }

    @Override
    public RequestFunctionValue value(final V context)
        throws ExecutionException
    {
        Predicate<Header> headersFilter = headersFilter(context);
        BasicAsyncRequestProducerGenerator producerGenerator =
            producerGenerator(context);
        DecodableByteArrayOutputStream out =
            new DecodableByteArrayOutputStream(
                producerGenerator.expectedLength(headersFilter));
        producerGenerator.appendTo(out, headersFilter);
        return new BinaryValue(out);
    }

    @Override
    public String toString() {
        return "request" + Arrays.toString(args);
    }
}
