package ru.yandex.ljinx.function;

import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;

import org.apache.http.Header;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpRequest;

import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.request.function.RequestFunction;

public class RequestDataFunctionBase<V extends LjinxFunctionContext> {
    protected final RequestFunction<V>[] args;

    @SuppressWarnings("unchecked")
    public RequestDataFunctionBase(final RequestFunction<V>... args) {
        this.args = args;
    }

    public Predicate<Header> headersFilter(final V context)
        throws ExecutionException
    {
        Set<String> headers = new TreeSet<>(String.CASE_INSENSITIVE_ORDER);
        headers.add(HttpHeaders.ACCEPT_ENCODING);
        headers.add(HttpHeaders.ACCEPT_CHARSET);
        for (RequestFunction<V> arg: args) {
            headers.add(arg.value(context).stringValue());
        }
        return header -> headers.contains(header.getName());
    }

    protected BasicAsyncRequestProducerGenerator producerGenerator(
        final V context)
        throws ExecutionException
    {
        if (args.length == 0) {
            return context.producerGenerator();
        } else {
            BasicAsyncRequestProducerGenerator producerGenerator =
                new BasicAsyncRequestProducerGenerator(
                    context.producerGenerator());
            HttpRequest request = context.request();
            for (RequestFunction<V> arg: args) {
                producerGenerator.copyHeader(
                    request,
                    arg.value(context).stringValue());
            }
            return producerGenerator;
        }
    }
}

