package ru.yandex.ljinx.function;

import java.util.Arrays;
import java.util.concurrent.ExecutionException;

import com.twmacinta.util.MD5;

import ru.yandex.http.util.request.function.RequestFunction;
import ru.yandex.http.util.request.function.RequestFunctionValue;
import ru.yandex.http.util.request.function.StringValue;
import ru.yandex.util.string.HexStrings;

public class RequestMd5Function<V extends LjinxFunctionContext>
    extends RequestDataFunctionBase<V>
    implements RequestFunction<V>
{
    @SuppressWarnings("unchecked")
    public RequestMd5Function(final RequestFunction<V>... args) {
        super(args);
    }

    @Override
    public RequestFunctionValue value(final V session)
        throws ExecutionException
    {
        MD5 md5 = new MD5();
        producerGenerator(session).appendTo(md5, headersFilter(session));
        return new StringValue(
            new String(HexStrings.UPPER.process(md5.Final())));
    }

    @Override
    public String toString() {
        return "request-md5" + Arrays.toString(args);
    }
}
