package ru.yandex.ljinx.function;

import java.text.ParseException;
import java.util.concurrent.ExecutionException;

import ru.yandex.http.util.request.function.HostListValue;
import ru.yandex.http.util.request.function.RequestFunction;
import ru.yandex.http.util.request.function.RequestFunctionValue;
import ru.yandex.parser.searchmap.User;

public class SearchMapHostsFunction<V extends LjinxFunctionContext>
    implements RequestFunction<V>
{
    private final RequestFunction<V> service;
    private final RequestFunction<V> prefix;

    public SearchMapHostsFunction(final RequestFunction<V>[] args)
        throws ParseException
    {
        if (args.length != 2) {
            throw new ParseException(
                "Function \"searchmap-hosts\" accepts exactly 2 arguments",
                0);
        }
        service = args[0];
        prefix = args[1];
    }

    @Override
    public RequestFunctionValue value(final V session)
        throws ExecutionException
    {
        String service = this.service.value(session).stringValue();
        try {
            return new HostListValue(
                session.searchMap().searchHosts(
                    new User(
                        service,
                        session.searchMap().prefixType(service).parse(
                            prefix.value(session).stringValue()))));
        } catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public String toString() {
        return "searchmap-hosts(" + service + ',' + prefix + ')';
    }
}

