package ru.yandex.ljinx.function;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

import org.apache.http.HttpHost;

import ru.yandex.http.util.request.function.HostListValue;
import ru.yandex.http.util.request.function.RequestFunction;
import ru.yandex.http.util.request.function.RequestFunctionValue;

public class SetPortFunction<V extends LjinxFunctionContext>
    implements RequestFunction<V>
{
    private final RequestFunction<V> hosts;
    private final RequestFunction<V> port;

    public SetPortFunction(final RequestFunction<V>[] args)
        throws ParseException
    {
        if (args.length != 2) {
            throw new ParseException(
                "Function \"set-port\" accepts exactly 2 arguments",
                0);
        }
        hosts = args[0];
        port = args[1];
    }

    @Override
    public RequestFunctionValue value(final V session)
        throws ExecutionException
    {
        int port = (int) this.port.value(session).longValue();
        List<HttpHost> hosts = this.hosts.value(session).hostListValue();
        List<HttpHost> result = new ArrayList<>(hosts.size());
        for (HttpHost host: hosts) {
            result.add(
                new HttpHost(
                    host.getHostName(),
                    port,
                    host.getSchemeName()));
        }
        return new HostListValue(result);
    }

    @Override
    public String toString() {
        return "port-port(" + hosts + ',' + port + ')';
    }
}

