package ru.yandex.ljinx.function;

import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;

import org.apache.http.HttpHost;

import ru.yandex.http.util.request.function.HostListValue;
import ru.yandex.http.util.request.function.RequestFunction;
import ru.yandex.http.util.request.function.RequestFunctionValue;

public class TruncateHostsFunction<V extends LjinxFunctionContext>
    implements RequestFunction<V>
{
    private final RequestFunction<V>[] args;

    public TruncateHostsFunction(final RequestFunction<V>[] args)
        throws ParseException
    {
        this.args = args.clone();
        if (args.length != 2) {
            throw new ParseException(
                "Function \"truncate-hosts\" accepts exactly 2 arguments",
                0);
        }
    }

    @Override
    public RequestFunctionValue value(final V session)
        throws ExecutionException
    {
        long size = args[1].value(session).longValue();
        RequestFunctionValue value = args[0].value(session);
        List<HttpHost> hosts = value.hostListValue();
        if (hosts.size() > size) {
            return new HostListValue(hosts.subList(0, (int) size));
        } else {
            return value;
        }
    }

    @Override
    public String toString() {
        return "truncate-hosts" + Arrays.toString(args);
    }
}

