package ru.yandex.stater;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

import ru.yandex.olelole.config.NotificationConfig;
import ru.yandex.olelole.config.NotificationConfigBuilder;
import ru.yandex.olelole.config.NotificationConfigDefaults;
import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractGolovanAlertsConfigBuilder
    <T extends AbstractGolovanAlertsConfigBuilder<T>>
    implements ConfigBuilder<T>, GolovanAlertsConfig
{
    private String namespace;
    private String module;
    private String wikiPrefix;
    private String yasmPanel;
    private String yasmTemplate;
    private Integer stableTime;
    private Integer critTime;
    private Map<String, NotificationConfigBuilder> notificationsConfigs;
    private Map<String, NotificationConfigBuilder>
        disasterNotificationsConfigs;

    protected AbstractGolovanAlertsConfigBuilder(
        final GolovanAlertsConfig config)
    {
        namespace(config.namespace());
        module(config.module());
        wikiPrefix(config.wikiPrefix());
        yasmPanel(config.yasmPanel());
        yasmTemplate(config.yasmTemplate());
        stableTime(config.stableTime());
        critTime(config.critTime());
        notificationsConfigs(config.notificationsConfigs());
        disasterNotificationsConfigs(config.disasterNotificationsConfigs());
    }

    protected AbstractGolovanAlertsConfigBuilder(
        final IniConfig config,
        final GolovanAlertsConfig defaults)
        throws ConfigException
    {
        namespace = NAMESPACE.extract(config, defaults.namespace());
        module = MODULE.extract(config, defaults.module());
        wikiPrefix = WIKI_PREFIX.extract(config, defaults.wikiPrefix());
        yasmPanel = YASM_PANEL.extract(config, defaults.yasmPanel());
        yasmTemplate = YASM_TEMPLATE.extract(config, defaults.yasmTemplate());
        stableTime = STABLE_TIME.extract(config, defaults.stableTime());
        critTime = CRIT_TIME.extract(config, defaults.critTime());

        IniConfig notificationsSection = config.section("notifications");
        Set<String> notifications = notificationsSection.sections().keySet();
        notificationsConfigs = new LinkedHashMap<>(notifications.size() << 1);
        for (String notification: notifications) {
            notificationsConfigs.put(
                notification,
                GolovanAlertsConfig.notificationConfigParser(notification)
                    .extract(
                        notificationsSection,
                        NotificationConfigDefaults.INSTANCE));
        }

        notificationsSection = config.section("disaster-notifications");
        notifications = notificationsSection.sections().keySet();
        disasterNotificationsConfigs =
            new LinkedHashMap<>(notifications.size() << 1);
        for (String notification: notifications) {
            disasterNotificationsConfigs.put(
                notification,
                GolovanAlertsConfig.notificationConfigParser(notification)
                    .extract(
                        notificationsSection,
                        NotificationConfigDefaults.INSTANCE));
        }
    }

    @Override
    public String namespace() {
        return namespace;
    }

    public T namespace(final String namespace) {
        this.namespace = namespace;
        return self();
    }

    @Override
    public String module() {
        return module;
    }

    public T module(final String module) {
        this.module = module;
        return self();
    }

    @Override
    public String wikiPrefix() {
        return wikiPrefix;
    }

    public T wikiPrefix(final String wikiPrefix) {
        this.wikiPrefix = wikiPrefix;
        return self();
    }

    @Override
    public String yasmPanel() {
        return yasmPanel;
    }

    public T yasmPanel(final String yasmPanel) {
        this.yasmPanel = yasmPanel;
        return self();
    }

    @Override
    public String yasmTemplate() {
        return yasmTemplate;
    }

    public T yasmTemplate(final String yasmTemplate) {
        this.yasmTemplate = yasmTemplate;
        return self();
    }

    @Override
    public Integer stableTime() {
        return stableTime;
    }

    public T stableTime(final Integer stableTime) {
        this.stableTime = stableTime;
        return self();
    }

    @Override
    public Integer critTime() {
        return critTime;
    }

    public T critTime(final Integer critTime) {
        this.critTime = critTime;
        return self();
    }

    @Override
    public Map<String, NotificationConfigBuilder> notificationsConfigs() {
        return notificationsConfigs;
    }

    public T notificationsConfigs(
        final Map<String, ? extends NotificationConfig> notificationsConfigs)
    {
        this.notificationsConfigs =
            new LinkedHashMap<>(notificationsConfigs.size() << 1);
        for (Map.Entry<String, ? extends NotificationConfig> entry
            : notificationsConfigs.entrySet())
        {
            this.notificationsConfigs.put(
                entry.getKey(),
                new NotificationConfigBuilder(entry.getValue()));
        }
        return self();
    }

    @Override
    public Map<String, NotificationConfigBuilder>
    disasterNotificationsConfigs()
    {
        return disasterNotificationsConfigs;
    }

    public T disasterNotificationsConfigs(
        final Map<String, ? extends NotificationConfig>
        disasterNotificationsConfigs)
    {
        this.disasterNotificationsConfigs =
            new LinkedHashMap<>(disasterNotificationsConfigs.size() << 1);
        for (Map.Entry<String, ? extends NotificationConfig> entry
            : disasterNotificationsConfigs.entrySet())
        {
            this.disasterNotificationsConfigs.put(
                entry.getKey(),
                new NotificationConfigBuilder(entry.getValue()));
        }
        return self();
    }
}

