package ru.yandex.stater;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractGolovanPanelConfigBuilder
    <T extends AbstractGolovanPanelConfigBuilder<T>>
    implements ConfigBuilder<T>, GolovanPanelConfig
{
    private String title;
    private String abc;
    private List<String> editors;
    private List<String> categoriesOrder;
    private String prefix;
    private String tag;
    private String splitBy;
    private List<Map.Entry<String, String>> splitValues;
    private int maxCols;
    private List<String> diskVolumes;
    private Map<String, String> rename;
    private Map<String, String> renameCategories;
    private GolovanAlertsConfigBuilder alerts;

    protected AbstractGolovanPanelConfigBuilder(
        final GolovanPanelConfig config)
    {
        title(config.title());
        abc(config.abc());
        editors(config.editors());
        categoriesOrder(config.categoriesOrder());
        prefix(config.prefix());
        tag(config.tag());
        splitBy(config.splitBy());
        splitValues(config.splitValues());
        maxCols(config.maxCols());
        diskVolumes(config.diskVolumes());
        rename(config.rename());
        renameCategories(config.renameCategories());
        alerts(config.alerts());
    }

    protected AbstractGolovanPanelConfigBuilder(
        final IniConfig config,
        final GolovanPanelConfig defaults)
        throws ConfigException
    {
        title = TITLE.extract(config, defaults.title());
        abc = ABC.extract(config, defaults.abc());
        editors = EDITORS.extract(config, defaults.editors());
        categoriesOrder =
            CATEGORIES_ORDER.extract(config, defaults.categoriesOrder());
        prefix = PREFIX.extract(config, defaults.prefix());
        tag = TAG.extract(config, defaults.tag());
        splitBy = SPLIT_BY.extract(config, defaults.splitBy());
        splitValues = SPLIT_VALUES.extract(config, defaults.splitValues());
        maxCols = MAX_COLS.extract(config, defaults.maxCols());
        diskVolumes = DISK_VOLUMES.extract(config, defaults.diskVolumes());
        rename = RENAME.extract(config, defaults.rename());
        renameCategories =
            RENAME_CATEGORIES.extract(config, defaults.renameCategories());
        alerts = ALERTS.extract(config, defaults.alerts());
    }

    @Override
    public String title() {
        return title;
    }

    public T title(final String title) {
        this.title = title;
        return self();
    }

    @Override
    public String abc() {
        return abc;
    }

    public T abc(final String abc) {
        this.abc = abc;
        return self();
    }

    @Override
    public List<String> editors() {
        return editors;
    }

    public T editors(final List<String> editors) {
        this.editors = new ArrayList<>(editors);
        return self();
    }

    @Override
    public String splitBy() {
        return splitBy;
    }

    public T splitBy(final String splitBy) {
        this.splitBy = splitBy;
        return self();
    }

    @Override
    public List<Map.Entry<String, String>> splitValues() {
        return splitValues;
    }

    public T splitValues(final List<Map.Entry<String, String>> geos) {
        this.splitValues = new ArrayList<>(geos);
        return self();
    }

    @Override
    public List<String> categoriesOrder() {
        return categoriesOrder;
    }

    public T categoriesOrder(final List<String> categoriesOrder) {
        this.categoriesOrder = new ArrayList<>(categoriesOrder);
        return self();
    }

    @Override
    public String prefix() {
        return prefix;
    }

    public T prefix(final String prefix) {
        this.prefix = prefix;
        return self();
    }

    @Override
    public String tag() {
        return tag;
    }

    public T tag(final String tag) {
        this.tag = tag;
        return self();
    }

    @Override
    public int maxCols() {
        return maxCols;
    }

    public T maxCols(final int maxCols) {
        this.maxCols = maxCols;
        return self();
    }

    @Override
    public List<String> diskVolumes() {
        return diskVolumes;
    }

    public T diskVolumes(final List<String> diskVolumes) {
        this.diskVolumes = new ArrayList<>(diskVolumes);
        return self();
    }

    @Override
    public Map<String, String> rename() {
        return rename;
    }

    public T rename(final Map<String, String> rename) {
        this.rename = new LinkedHashMap<>(rename);
        return self();
    }

    @Override
    public Map<String, String> renameCategories() {
        return renameCategories;
    }

    public T renameCategories(final Map<String, String> renameCategories) {
        this.renameCategories = new HashMap<>(renameCategories);
        return self();
    }

    @Override
    public GolovanAlertsConfigBuilder alerts() {
        return alerts;
    }

    public T alerts(final GolovanAlertsConfig alerts) {
        if (alerts == null) {
            this.alerts = null;
        } else {
            this.alerts = new GolovanAlertsConfigBuilder(alerts);
        }
        return self();
    }
}

