package ru.yandex.stater;

import ru.yandex.olelole.config.AlertWindowConfig;
import ru.yandex.olelole.config.AlertWindowConfigBuilder;
import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractHttpCodesAlertsConfigBuilder
    <T extends AbstractHttpCodesAlertsConfigBuilder<T>>
    implements ConfigBuilder<T>, HttpCodesAlertsConfig
{
    private GolovanAlertThreshold errorsThreshold;
    private Integer minValue;
    private AlertWindowConfigBuilder alertWindow;

    protected AbstractHttpCodesAlertsConfigBuilder(
        final HttpCodesAlertsConfig config)
    {
        errorsThreshold(config.errorsThreshold());
        minValue(config.minValue());
        alertWindow(config.alertWindow());
    }

    protected AbstractHttpCodesAlertsConfigBuilder(
        final IniConfig config,
        final HttpCodesAlertsConfig defaults)
        throws ConfigException
    {
        errorsThreshold =
            ERRORS_THRESHOLD.extract(config, defaults.errorsThreshold());
        minValue = MIN_VALUE.extract(config, defaults.minValue());
        alertWindow = ALERT_WINDOW.extract(config, defaults.alertWindow());
    }

    @Override
    public GolovanAlertThreshold errorsThreshold() {
        return errorsThreshold;
    }

    public T errorsThreshold(final GolovanAlertThreshold errorsThreshold) {
        this.errorsThreshold = errorsThreshold;
        return self();
    }

    @Override
    public Integer minValue() {
        return minValue;
    }

    public T minValue(final Integer minValue) {
        this.minValue = minValue;
        return self();
    }

    @Override
    public AlertWindowConfigBuilder alertWindow() {
        return alertWindow;
    }

    public T alertWindow(final AlertWindowConfig alertWindow) {
        if (alertWindow == null) {
            this.alertWindow = null;
        } else {
            this.alertWindow = new AlertWindowConfigBuilder(alertWindow);
        }
        return self();
    }
}

