package ru.yandex.stater;

import java.util.ArrayList;
import java.util.List;

public abstract class AbstractStatable implements Stater {
    protected final List<Stater> staters = new ArrayList<>();

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        synchronized (staters) {
            for (Stater stater: staters) {
                stater.stats(statsConsumer);
            }
        }
    }

    public void registerStater(final Stater stater) {
        synchronized (staters) {
            staters.add(stater);
        }
    }
}
