package ru.yandex.stater;

import java.util.Map;

import ru.yandex.collection.Pattern;
import ru.yandex.collection.PatternMap;
import ru.yandex.collection.PatternStringPredicate;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.http.util.request.RequestPatternParser;
import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractStatersConfigBuilder
    <T extends AbstractStatersConfigBuilder<T>>
    implements ConfigBuilder<T>, StatersConfig
{
    private PatternMap<RequestInfo, StaterConfigBuilder> staters;

    protected AbstractStatersConfigBuilder(final StatersConfig config) {
        staters(config.staters());
    }

    protected AbstractStatersConfigBuilder(
        final IniConfig config,
        final StatersConfig defaults)
        throws ConfigException
    {
        staters = loadStaters(config.section("stat"), defaults.staters());
    }

    public static PatternMap<RequestInfo, StaterConfigBuilder> loadStaters(
        final IniConfig section,
        final PatternMap<RequestInfo, ? extends StaterConfig> defaults)
        throws ConfigException
    {
        PatternMap<RequestInfo, StaterConfigBuilder> staters =
            new PatternMap<>(
                new StaterConfigBuilder(section, defaults.asterisk()));
        for (Map.Entry<String, IniConfig> entry
                : section.sections().entrySet())
        {
            String subsection = entry.getKey();
            if (PatternStringPredicate.INSTANCE.test(subsection)) {
                Pattern<RequestInfo> pattern =
                    RequestPatternParser.INSTANCE.apply(subsection);
                staters.put(
                    pattern,
                    new StaterConfigBuilder(
                        entry.getValue(),
                        defaults.get(pattern)));
            }
        }
        return staters;
    }

    @Override
    public PatternMap<RequestInfo, StaterConfigBuilder> staters() {
        return staters;
    }

    public T staters(
        final PatternMap<RequestInfo, ? extends StaterConfig> staters)
    {
        this.staters =
            staters.transform(config -> new StaterConfigBuilder(config));
        return self();
    }
}

