package ru.yandex.stater;

import java.util.Objects;

import javax.annotation.Nullable;

import ru.yandex.olelole.config.AlertWindowConfig;
import ru.yandex.olelole.config.ImmutableAlertWindowConfig;
import ru.yandex.parser.config.IniConfig;

public class AlertThresholds {
    @Nullable
    private final Double critLeft;
    @Nullable
    private final Double critRight;
    @Nullable
    private final ImmutableAlertWindowConfig window;

    public AlertThresholds(
        @Nullable final Double critLeft,
        @Nullable final Double critRight,
        @Nullable final ImmutableAlertWindowConfig window)
    {
        this.critLeft = critLeft;
        this.critRight = critRight;
        this.window = window;
    }

    public void toIniConfig(final IniConfig config) {
        config.put(
            "crit",
            Objects.toString(critLeft, "")
            + '-' + Objects.toString(critRight, ""));
        if (window != null) {
            AlertWindowConfig.toIniConfig(config.section("window"), window);
        }
    }
}

