package ru.yandex.stater;

import java.util.Map;
import java.util.Set;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.config.IniConfig;

public class AliasingStater implements Stater {
    private final Stater stater;
    private final Map<String, Set<String>> aliases;

    public AliasingStater(
        final Stater stater,
        final Map<String, Set<String>> aliases)
    {
        this.stater = stater;
        this.aliases = aliases;
    }

    public static Stater create(
        final Stater stater,
        final Map<String, Set<String>> aliases)
    {
        if (aliases.isEmpty()) {
            return stater;
        } else {
            return new AliasingStater(stater, aliases);
        }
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        stater.stats(new AliasingStatsConsumer<>(statsConsumer, aliases));
    }

    @Override
    public final void addToGolovanPanel(
        final GolovanPanel panel,
        final String statsPrefix)
    {
        stater.addToGolovanPanel(panel, statsPrefix);
    }

    @Override
    public void addToAlertsConfig(
        final IniConfig alertsConfig,
        final ImmutableGolovanPanelConfig panelConfig,
        final String statsPrefix)
        throws BadRequestException
    {
        stater.addToAlertsConfig(alertsConfig, panelConfig, statsPrefix);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AliasingStater[aliases=");
        sb.append(aliases);
        sb.append(" stater=");
        sb.append(stater);
        sb.append(']');
        return new String(sb);
    }
}

