package ru.yandex.stater;

import java.util.Map;
import java.util.Set;

public class AliasingStatsConsumer<E extends Exception>
    implements StatsConsumer<E>
{
    private final StatsConsumer<? extends E> statsConsumer;
    private final Map<String, Set<String>> aliases;

    public AliasingStatsConsumer(
        final StatsConsumer<? extends E> statsConsumer,
        final Map<String, Set<String>> aliases)
    {
        this.statsConsumer = statsConsumer;
        this.aliases = aliases;
    }

    @Override
    public void stat(final String name, final boolean value) throws E {
        statsConsumer.stat(name, value);
        Set<String> aliases = this.aliases.get(name);
        if (aliases != null) {
            for (String alias: aliases) {
                statsConsumer.stat(alias, value);
            }
        }
    }

    @Override
    public void stat(final String name, final long value) throws E {
        statsConsumer.stat(name, value);
        Set<String> aliases = this.aliases.get(name);
        if (aliases != null) {
            for (String alias: aliases) {
                statsConsumer.stat(alias, value);
            }
        }
    }

    @Override
    public void stat(final String name, final double value) throws E {
        statsConsumer.stat(name, value);
        Set<String> aliases = this.aliases.get(name);
        if (aliases != null) {
            for (String alias: aliases) {
                statsConsumer.stat(alias, value);
            }
        }
    }

    @Override
    public void stat(final String name, final long[] value) throws E {
        statsConsumer.stat(name, value);
        Set<String> aliases = this.aliases.get(name);
        if (aliases != null) {
            for (String alias: aliases) {
                statsConsumer.stat(alias, value);
            }
        }
    }
}

