package ru.yandex.stater;

public class AveragingAggregator implements StatsAggregator<Number> {
    private long sum = 0L;
    private int count = 0;

    @Override
    public void accept(final Number value) {
        sum += value.longValue();
        ++count;
    }

    @Override
    public <E extends Exception> void stat(
            final StatsConsumer<? extends E> statsConsumer,
            final String name)
    throws E
    {
        statsConsumer.stat(name, count == 0 ? 0 : (double) sum / count);
    }
}


