package ru.yandex.stater;

import ru.yandex.util.string.StringUtils;

public class BooleanStater implements Stater {
    private final Iterable<?> data;
    private final String trueSignal;
    private final String falseSignal;
    private final String nullSignal;
    private final String totalSignal;

    public BooleanStater(
        final Iterable<?> data,
        final String signalPrefix)
    {
        this.data = data;
        trueSignal = StringUtils.concat(signalPrefix, "true_ammm");
        falseSignal = StringUtils.concat(signalPrefix, "false_ammm");
        nullSignal = StringUtils.concat(signalPrefix, "null_ammm");
        totalSignal = StringUtils.concat(signalPrefix, "total_ammm");
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        int trues = 0;
        int falses = 0;
        int nulls = 0;
        int total = 0;
        for (Object b: data) {
            if (Boolean.TRUE.equals(b)) {
                ++trues;
            } else if (Boolean.FALSE.equals(b)) {
                ++falses;
            } else {
                ++nulls;
            }
            ++total;
        }
        statsConsumer.stat(trueSignal, trues);
        statsConsumer.stat(falseSignal, falses);
        statsConsumer.stat(nullSignal, nulls);
        statsConsumer.stat(totalSignal, total);
    }
}

