package ru.yandex.stater;

public class CountAggregator implements StatsAggregator<Object> {
    private long count = 0L;

    @Override
    public void accept(final Object value) {
        ++count;
    }

    @Override
    public <E extends Exception> void stat(
        final StatsConsumer<? extends E> statsConsumer,
        final String name)
        throws E
    {
        statsConsumer.stat(name, count);
    }
}

