package ru.yandex.stater;

public class DuplexStater<T> implements PassiveStater<T> {
    private final PassiveStater<? super T> first;
    private final PassiveStater<? super T> second;

    public DuplexStater(
        final PassiveStater<? super T> first,
        final PassiveStater<? super T> second)
    {
        this.first = first;
        this.second = second;
    }

    @Override
    public void accept(final T value) {
        first.accept(value);
        second.accept(value);
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        first.stats(statsConsumer);
        second.stats(statsConsumer);
    }
}

