package ru.yandex.stater;

import java.util.function.Supplier;

public class DuplexStaterFactory<T> implements Supplier<DuplexStater<T>> {
    private final Supplier<? extends PassiveStater<? super T>> first;
    private final Supplier<? extends PassiveStater<? super T>> second;

    public DuplexStaterFactory(
        final Supplier<? extends PassiveStater<? super T>> first,
        final Supplier<? extends PassiveStater<? super T>> second)
    {
        this.first = first;
        this.second = second;
    }

    @Override
    public DuplexStater<T> get() {
        return new DuplexStater<>(first.get(), second.get());
    }
}

