package ru.yandex.stater;

import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class EnumStaterFactory<T extends Enum<T>>
    implements Supplier<EnumStater<T>>
{
    private final UnaryOperator<String> enumToSignal;
    private final T[] possibleValues;
    private final Class<T> clazz;
    private final String signalPrefix;
    private final String category;
    private final String name;
    private final String title;
    private final Integer fractionSize;

    public EnumStaterFactory(
        final UnaryOperator<String> enumToSignal,
        final T[] possibleValues)
    {
        this(enumToSignal, possibleValues, "");
    }

    public EnumStaterFactory(
        final UnaryOperator<String> enumToSignal,
        final T[] possibleValues,
        final String signalPrefix)
    {
        this(
            enumToSignal,
            possibleValues,
            signalPrefix,
            null,
            null,
            null,
            null);
    }

    @SuppressWarnings("unchecked")
    public EnumStaterFactory(
        final UnaryOperator<String> enumToSignal,
        final T[] possibleValues,
        final String signalPrefix,
        final String category,
        final String name,
        final String title,
        final Integer fractionSize)
    {
        this.enumToSignal = enumToSignal;
        this.possibleValues = possibleValues.clone();
        Class<?> clazz = possibleValues[0].getDeclaringClass();
        this.clazz = (Class<T>) clazz;
        this.signalPrefix = signalPrefix;
        this.category = category;
        this.name = name;
        this.title = title;
        this.fractionSize = fractionSize;
    }

    @Override
    public EnumStater<T> get() {
        return new EnumStater<>(
            clazz,
            enumToSignal,
            possibleValues,
            signalPrefix,
            category,
            name,
            title,
            fractionSize);
    }
}

