package ru.yandex.stater;

import java.util.function.Predicate;

public class FilterPassiveStater<T> implements PassiveStater<T> {
    private final Predicate<? super T> predicate;
    private final PassiveStater<? super T> stater;

    public FilterPassiveStater(
        final Predicate<? super T> predicate,
        final PassiveStater<? super T> stater)
    {
        this.predicate = predicate;
        this.stater = stater;
    }

    @Override
    public void accept(final T t) {
        if (predicate.test(t)) {
            stater.accept(t);
        }
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        stater.stats(statsConsumer);
    }
}

