package ru.yandex.stater;

import java.util.function.Predicate;
import java.util.function.Supplier;

public class FilterPassiveStaterFactory<T>
    implements Supplier<FilterPassiveStater<T>>
{
    private final Predicate<? super T> predicate;
    private final Supplier<? extends PassiveStater<? super T>> staterSupplier;

    public FilterPassiveStaterFactory(
        final Predicate<? super T> predicate,
        final Supplier<? extends PassiveStater<? super T>> staterSupplier)
    {
        this.predicate = predicate;
        this.staterSupplier = staterSupplier;
    }

    @Override
    public FilterPassiveStater<T> get() {
        return new FilterPassiveStater<>(predicate, staterSupplier.get());
    }
}

