package ru.yandex.stater;

import java.util.function.Function;

public class FunctionPassiveStater<T, R> implements PassiveStater<T> {
    private final Function<? super T, ? extends R> function;
    private final PassiveStater<? super R> stater;

    public FunctionPassiveStater(
        final Function<? super T, ? extends R> function,
        final PassiveStater<? super R> stater)
    {
        this.function = function;
        this.stater = stater;
    }

    @Override
    public void accept(final T t) {
        stater.accept(function.apply(t));
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        stater.stats(statsConsumer);
    }
}

