package ru.yandex.stater;

import java.util.function.Function;
import java.util.function.Supplier;

public class FunctionPassiveStaterFactory<T, R>
    implements Supplier<FunctionPassiveStater<T, R>>
{
    private final Function<? super T, ? extends R> function;
    private final Supplier<? extends PassiveStater<? super R>> staterSupplier;

    public FunctionPassiveStaterFactory(
        final Function<? super T, ? extends R> function,
        final Supplier<? extends PassiveStater<? super R>> staterSupplier)
    {
        this.function = function;
        this.staterSupplier = staterSupplier;
    }

    @Override
    public FunctionPassiveStater<T, R> get() {
        return new FunctionPassiveStater<>(function, staterSupplier.get());
    }
}

