package ru.yandex.stater;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ConfigException;

public class GolovanAlertThreshold {
    public enum Mode {
        ABSOLUTE {
            @Override
            public String toString(final double value) {
                return Double.toString(value);
            }
        },
        PERCENT {
            @Override
            public String toString(final double value) {
                return Double.toString(value) + '%';
            }
        };

        public abstract String toString(final double value);
    }

    private final Mode mode;
    private final double value;

    public GolovanAlertThreshold(final Mode mode, final double value) {
        this.mode = mode;
        this.value = value;
    }

    public Mode mode() {
        return mode;
    }

    public double value() {
        return value;
    }

    @Override
    public String toString() {
        return mode.toString(value);
    }

    public enum Parser
        implements GenericFunction
            <String, GolovanAlertThreshold, ConfigException>
    {
        INSTANCE;

        @Override
        public GolovanAlertThreshold apply(final String value) {
            int len = value.length();
            try {
                if (value.charAt(len - 1) == '%') {
                    return new GolovanAlertThreshold(
                        Mode.PERCENT,
                        Double.parseDouble(value.substring(0, len - 1)));
                } else {
                    return new GolovanAlertThreshold(
                        Mode.ABSOLUTE,
                        Double.parseDouble(value));
                }
            } catch (RuntimeException e) {
                throw new IllegalArgumentException(
                    "Can't parse threshold from <" + value + '>',
                    e);
            }
        }
    }
}

