package ru.yandex.stater;

import java.util.Map;
import java.util.regex.Pattern;

import ru.yandex.function.GenericFunction;
import ru.yandex.function.NullToDefaultFunction;
import ru.yandex.olelole.config.ImmutableNotificationConfig;
import ru.yandex.olelole.config.NotificationConfig;
import ru.yandex.olelole.config.NotificationConfigBuilder;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.config.SectionConfig;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.PositiveValidator;

public interface GolovanAlertsConfig {
    ParameterConfig<String> NAMESPACE =
        new ParameterConfig<>(
            "namespace",
            GenericFunction.identity(),
            NonEmptyValidator.INSTANCE);

    ParameterConfig<String> MODULE =
        new ParameterConfig<>(
            "module",
            GenericFunction.identity(),
            NonEmptyValidator.INSTANCE);

    ParameterConfig<String> WIKI_PREFIX =
        new ParameterConfig<>(
            "wiki-prefix",
            GenericFunction.identity(),
            NonEmptyValidator.INSTANCE);

    ParameterConfig<String> YASM_PANEL =
        new ParameterConfig<>(
            "yasm-panel",
            GenericFunction.identity(),
            GenericFunction.identity(),
            true);

    ParameterConfig<String> YASM_TEMPLATE =
        new ParameterConfig<>(
            "yasm-template",
            GenericFunction.identity(),
            GenericFunction.identity(),
            true);

    ParameterConfig<Integer> STABLE_TIME =
        new ParameterConfig<>(
            "stable-time",
            Integer::parseInt,
            new NullToDefaultFunction<>(PositiveValidator.instance()),
            true);

    ParameterConfig<Integer> CRIT_TIME =
        new ParameterConfig<>(
            "crit-time",
            Integer::parseInt,
            new NullToDefaultFunction<>(PositiveValidator.instance()),
            true);

    Pattern ALERT_NAME_BAD_CHARS = Pattern.compile("[^a-zA-Z0-9-]");

    static SectionConfig<
        NotificationConfig,
        ImmutableNotificationConfig,
        NotificationConfigBuilder>
    notificationConfigParser(final String notification) {
        return new SectionConfig<>(
            notification,
            NotificationConfigBuilder::new,
            ImmutableNotificationConfig::new);
    }

    static String clearAlertName(final String alertName) {
        return ALERT_NAME_BAD_CHARS.matcher(alertName).replaceAll("");
    }

    String namespace();

    String module();

    String wikiPrefix();

    String yasmPanel();

    String yasmTemplate();

    Integer stableTime();

    Integer critTime();

    Map<String, ? extends NotificationConfig> notificationsConfigs();

    Map<String, ? extends NotificationConfig> disasterNotificationsConfigs();
}


