package ru.yandex.stater;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class GolovanAlertsConfigBuilder
    extends AbstractGolovanAlertsConfigBuilder<GolovanAlertsConfigBuilder>
{
    public GolovanAlertsConfigBuilder() {
        super(GolovanAlertsConfigDefaults.INSTANCE);
    }

    public GolovanAlertsConfigBuilder(final GolovanAlertsConfig config) {
        super(config);
    }

    public GolovanAlertsConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, GolovanAlertsConfigDefaults.INSTANCE);
    }

    public GolovanAlertsConfigBuilder(
        final IniConfig config,
        final GolovanAlertsConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public GolovanAlertsConfigBuilder self() {
        return this;
    }

    public ImmutableGolovanAlertsConfig build() throws ConfigException {
        return new ImmutableGolovanAlertsConfig(this);
    }
}

