package ru.yandex.stater;

import java.util.ArrayList;
import java.util.List;

public class GolovanChartGroup {
    private final List<GolovanChart> charts = new ArrayList<>();
    private final String id;
    private final String statsPrefix;

    public GolovanChartGroup(final String id, final String statsPrefix) {
        this.id = id;
        this.statsPrefix = statsPrefix;
    }

    public boolean isEmpty() {
        return charts.isEmpty();
    }

    public List<GolovanChart> charts() {
        return charts;
    }

    public String id() {
        return id;
    }

    public String statsPrefix() {
        return statsPrefix;
    }

    public void addChart(final GolovanChart chart) {
        if (!chart.isEmpty()) {
            charts.add(chart);
        }
    }
}

