package ru.yandex.stater;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.NullableSectionConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.config.ParameterMapConfig;
import ru.yandex.parser.string.AliasParser;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.CollectionValidator;
import ru.yandex.parser.string.NonEmptyCollectionValidator;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.PositiveValidator;

public interface GolovanPanelConfig {
    // rps, timings, average request time
    static String CATEGORY_TIMINGS = "timings";
    // upstreams rps, timings, average request time
    static String CATEGORY_UPSTREAMS = "upstreams";
    // incoming connections, active connections, limited connections,
    // synchronous tasks
    static String CATEGORY_CONNECTIONS = "connections";
    // concurrent requests count, requests size, limits if any
    static String CATEGORY_LIMITER = "limiter";
    // rusage, porto cpu usage, uptime, instances alive
    static String CATEGORY_SYSTEM_INFO = "system-info";
    // absolute memory usage, memory usage percentage, anon memory usage
    static String CATEGORY_MEMORY = "memory";
    // thread pools active workers and queues
    static String CATEGORY_THREAD_POOLS = "thread-pools";

    ParameterConfig<String> TITLE = new ParameterConfig<>(
        "title",
        GenericFunction.identity(),
        GenericFunction.identity());
    ParameterConfig<String> ABC = new ParameterConfig<>(
        "abc",
        GenericFunction.identity(),
        GenericFunction.identity());
    ParameterConfig<List<String>> EDITORS = new ParameterConfig<>(
        "editors",
        new CollectionParser<>(NonEmptyValidator.TRIMMED, ArrayList::new),
        new CollectionValidator<String, List<String>>(
            NonEmptyValidator.INSTANCE)
            .andThen(NonEmptyCollectionValidator.instance())
            .andThen(ArrayList::new));
    ParameterConfig<List<String>> CATEGORIES_ORDER = new ParameterConfig<>(
        "categories-order",
        new CollectionParser<>(NonEmptyValidator.TRIMMED, ArrayList::new),
        new CollectionValidator<String, List<String>>(
            NonEmptyValidator.INSTANCE)
            .andThen(NonEmptyCollectionValidator.instance())
            .andThen(ArrayList::new));
    ParameterConfig<String> PREFIX = new ParameterConfig<>(
        "prefix",
        GenericFunction.identity(),
        GenericFunction.identity());
    ParameterConfig<String> TAG = new ParameterConfig<>(
        "tag",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);
    ParameterConfig<String> SPLIT_BY = new ParameterConfig<>(
        "split-by",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);
    ParameterConfig<List<Map.Entry<String, String>>> SPLIT_VALUES =
        new ParameterConfig<>(
            "split-values",
            new CollectionParser<>(AliasParser.INSTANCE, ArrayList::new),
            NonEmptyCollectionValidator.<
                Map.Entry<String, String>,
                List<Map.Entry<String, String>>>
                instance()
                .andThen(ArrayList::new));
    ParameterConfig<Integer> MAX_COLS = new ParameterConfig<>(
        "max-cols",
        Integer::valueOf,
        PositiveValidator.instance());
    ParameterConfig<List<String>> DISK_VOLUMES = new ParameterConfig<>(
        "disk-volumes",
        new CollectionParser<>(NonEmptyValidator.TRIMMED, ArrayList::new),
        new CollectionValidator<String, List<String>>(
            NonEmptyValidator.INSTANCE)
            .andThen(ArrayList::new));
    ParameterMapConfig<String> RENAME = new ParameterMapConfig<>(
        "rename",
        String::trim,
        GenericFunction.identity(),
        size -> new LinkedHashMap<>(size << 1));
    ParameterMapConfig<String> RENAME_CATEGORIES = new ParameterMapConfig<>(
        "rename-categories",
        GenericFunction.identity(),
        NonEmptyValidator.TRIMMED,
        size -> new HashMap<>(size << 1));
    NullableSectionConfig<
        GolovanAlertsConfig,
        ImmutableGolovanAlertsConfig,
        GolovanAlertsConfigBuilder>
        ALERTS =
            new NullableSectionConfig<>(
                "alerts",
                GolovanAlertsConfigBuilder::new,
                ImmutableGolovanAlertsConfig::new,
                null,
                GolovanAlertsConfigDefaults.INSTANCE,
                null);

    String title();

    String abc();

    List<String> editors();

    List<String> categoriesOrder();

    String prefix();

    String tag();

    String splitBy();

    List<Map.Entry<String, String>> splitValues();

    int maxCols();

    List<String> diskVolumes();

    Map<String, String> rename();

    Map<String, String> renameCategories();

    GolovanAlertsConfig alerts();
}


