package ru.yandex.stater;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class GolovanPanelConfigBuilder
    extends AbstractGolovanPanelConfigBuilder<GolovanPanelConfigBuilder>
{
    public GolovanPanelConfigBuilder() {
        super(GolovanPanelConfigDefaults.INSTANCE);
    }

    public GolovanPanelConfigBuilder(final GolovanPanelConfig config) {
        super(config);
    }

    public GolovanPanelConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, GolovanPanelConfigDefaults.INSTANCE);
    }

    public GolovanPanelConfigBuilder(
        final IniConfig config,
        final GolovanPanelConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public GolovanPanelConfigBuilder self() {
        return this;
    }

    public ImmutableGolovanPanelConfig build() throws ConfigException {
        return new ImmutableGolovanPanelConfig(this);
    }
}

