package ru.yandex.stater;

import java.io.IOException;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class GolovanSignal implements JsonValue {
    private final String signalName;
    private final String tag;
    private final String title;
    private final String color;
    private Integer fractionSize;
    private boolean filled;

    public GolovanSignal(
        final String signalName,
        final String tag,
        final String title,
        final String color,
        final Integer fractionSize,
        final boolean filled)
    {
        this.signalName = signalName;
        this.tag = tag;
        this.title = title;
        this.color = color;
        this.fractionSize = fractionSize;
        this.filled = filled;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key("name");
        writer.value(signalName);
        writer.key("tag");
        writer.value(tag);
        writer.key("host");
        writer.value("ASEARCH");
        if (title != null) {
            writer.key("title");
            writer.value(title);
        }
        if (color != null) {
            writer.key("color");
            writer.value(color);
        }
        if (fractionSize != null) {
            writer.key("fractionSize");
            writer.value(fractionSize.intValue());
        }
        if (filled) {
            writer.key("filled");
            writer.value(true);
        }
        writer.endObject();
    }
}

