package ru.yandex.stater;

import ru.yandex.function.GenericFunction;
import ru.yandex.function.NullToDefaultFunction;
import ru.yandex.olelole.config.AlertWindowConfig;
import ru.yandex.olelole.config.AlertWindowConfigBuilder;
import ru.yandex.olelole.config.AlertWindowConfigDefaults;
import ru.yandex.olelole.config.ImmutableAlertWindowConfig;
import ru.yandex.parser.config.NullableSectionConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.PositiveValidator;

public interface HttpCodesAlertsConfig {
    ParameterConfig<GolovanAlertThreshold> ERRORS_THRESHOLD =
        new ParameterConfig<>(
            "errors-threshold",
            GolovanAlertThreshold.Parser.INSTANCE,
            GenericFunction.identity());

    ParameterConfig<Integer> MIN_VALUE =
        new ParameterConfig<>(
            "min-value",
            Integer::valueOf,
            new NullToDefaultFunction<>(PositiveValidator.instance()),
            true);

    NullableSectionConfig<
        AlertWindowConfig,
        ImmutableAlertWindowConfig,
        AlertWindowConfigBuilder>
        ALERT_WINDOW =
            new NullableSectionConfig<>(
                "alert-window",
                AlertWindowConfigBuilder::new,
                ImmutableAlertWindowConfig::new,
                null,
                AlertWindowConfigDefaults.INSTANCE,
                null);

    GolovanAlertThreshold errorsThreshold();

    Integer minValue();

    AlertWindowConfig alertWindow();
}


