package ru.yandex.stater;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class HttpCodesAlertsConfigBuilder
    extends AbstractHttpCodesAlertsConfigBuilder<HttpCodesAlertsConfigBuilder>
{
    public HttpCodesAlertsConfigBuilder() {
        super(HttpCodesAlertsConfigDefaults.INSTANCE);
    }

    public HttpCodesAlertsConfigBuilder(final HttpCodesAlertsConfig config) {
        super(config);
    }

    public HttpCodesAlertsConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, HttpCodesAlertsConfigDefaults.INSTANCE);
    }

    public HttpCodesAlertsConfigBuilder(
        final IniConfig config,
        final HttpCodesAlertsConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public HttpCodesAlertsConfigBuilder self() {
        return this;
    }

    public ImmutableHttpCodesAlertsConfig build() throws ConfigException {
        return new ImmutableHttpCodesAlertsConfig(this);
    }
}

