package ru.yandex.stater;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableGolovanPanelConfig
    implements GolovanPanelConfig, ImmutableConfig
{
    private final String title;
    private final String abc;
    private final List<String> editors;
    private final List<String> categoriesOrder;
    private final String prefix;
    private final String tag;
    private final String splitBy;
    private final List<Map.Entry<String, String>> splitValues;
    private final int maxCols;
    private final List<String> diskVolumes;
    private final Map<String, String> rename;
    private final Map<String, String> renameCategories;
    private final ImmutableGolovanAlertsConfig alerts;
    private final String splitTag;

    public ImmutableGolovanPanelConfig(final GolovanPanelConfig config)
        throws ConfigException
    {
        title = TITLE.validate(config.title());
        abc = ABC.validate(config.abc());
        editors = EDITORS.validate(config.editors());
        List<String> categoriesOrder =
            CATEGORIES_ORDER.validate(config.categoriesOrder());
        Set<String> categoriesOrderSet =
            new LinkedHashSet<>(categoriesOrder.size() << 1);
        for (String category: categoriesOrder) {
            if (category.equals("default-categories")) {
                categoriesOrderSet.addAll(
                    GolovanPanelConfigDefaults.INSTANCE.categoriesOrder());
            } else if (category.startsWith("-")) {
                categoriesOrderSet.remove(category.substring(1));
            } else {
                categoriesOrderSet.add(category);
            }
        }
        this.categoriesOrder = new ArrayList<>(categoriesOrderSet);
        prefix = PREFIX.validate(config.prefix());
        tag = TAG.validate(config.tag());
        splitBy = SPLIT_BY.validate(config.splitBy());
        splitValues = SPLIT_VALUES.validate(config.splitValues());
        maxCols = MAX_COLS.validate(config.maxCols());
        diskVolumes = DISK_VOLUMES.validate(config.diskVolumes());
        rename = RENAME.validate(config.rename());
        renameCategories =
            RENAME_CATEGORIES.validate(config.renameCategories());
        alerts = ALERTS.validate(config.alerts());
        splitTag = tag.replaceAll(
            "(?:;" + splitBy + "=[^;]+[*]|^" + splitBy + "=[^;]+[*];)", "");
    }

    @Override
    public String title() {
        return title;
    }

    @Override
    public String abc() {
        return abc;
    }

    @Override
    public List<String> editors() {
        return editors;
    }

    @Override
    public List<String> categoriesOrder() {
        return categoriesOrder;
    }

    @Override
    public String prefix() {
        return prefix;
    }

    @Override
    public String tag() {
        return tag;
    }

    public String splitTag() {
        return splitTag;
    }

    @Override
    public String splitBy() {
        return splitBy;
    }

    @Override
    public List<Map.Entry<String, String>> splitValues() {
        return splitValues;
    }

    @Override
    public int maxCols() {
        return maxCols;
    }

    @Override
    public List<String> diskVolumes() {
        return diskVolumes;
    }

    @Override
    public Map<String, String> rename() {
        return rename;
    }

    @Override
    public Map<String, String> renameCategories() {
        return renameCategories;
    }

    @Override
    public ImmutableGolovanAlertsConfig alerts() {
        return alerts;
    }

    public static ImmutableGolovanPanelConfig create(
        final GolovanPanelConfig config)
        throws ConfigException
    {
        if (config == null) {
            return null;
        } else {
            return new ImmutableGolovanPanelConfig(config);
        }
    }
}

