package ru.yandex.stater;

import ru.yandex.olelole.config.ImmutableAlertWindowConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableHttpCodesAlertsConfig
    implements HttpCodesAlertsConfig, ImmutableConfig
{
    private final GolovanAlertThreshold errorsThreshold;
    private final Integer minValue;
    private final ImmutableAlertWindowConfig alertWindow;

    public ImmutableHttpCodesAlertsConfig(final HttpCodesAlertsConfig config)
        throws ConfigException
    {
        errorsThreshold = ERRORS_THRESHOLD.validate(config.errorsThreshold());
        minValue = MIN_VALUE.validate(config.minValue());
        alertWindow = ALERT_WINDOW.validate(config.alertWindow());
    }

    @Override
    public GolovanAlertThreshold errorsThreshold() {
        return errorsThreshold;
    }

    @Override
    public Integer minValue() {
        return minValue;
    }

    @Override
    public ImmutableAlertWindowConfig alertWindow() {
        return alertWindow;
    }
}

