package ru.yandex.stater;

import java.util.List;

public class ImmutableStaterConfig implements StaterConfig {
    private final String prefix;
    private final List<MetricBuilder> metrics;
    private final long metricsTimeFrame;
    private final String category;
    private final String title;

    public ImmutableStaterConfig(final StaterConfig config) {
        prefix = config.prefix();
        metrics = config.metrics();
        metricsTimeFrame = config.metricsTimeFrame();
        category = config.category();
        title = config.title();
    }

    @Override
    public String prefix() {
        return prefix;
    }

    @Override
    public List<MetricBuilder> metrics() {
        return metrics;
    }

    @Override
    public long metricsTimeFrame() {
        return metricsTimeFrame;
    }

    @Override
    public String category() {
        return category;
    }

    @Override
    public String title() {
        return title;
    }

    public RequestsStater build() {
        return new RequestsStater(this);
    }
}
