package ru.yandex.stater;

import ru.yandex.collection.PatternMap;
import ru.yandex.http.util.request.RequestInfo;

public class ImmutableStatersConfig implements StatersConfig {
    private final PatternMap<RequestInfo, ImmutableStaterConfig> statersConfigs;
    private final PatternMap<RequestInfo, RequestsStater> staters;

    public ImmutableStatersConfig(final StatersConfig config) {
        statersConfigs = config.staters().transform(ImmutableStaterConfig::new);
        staters = statersConfigs.transform(ImmutableStaterConfig::build);
    }

    @Override
    public PatternMap<RequestInfo, ImmutableStaterConfig> staters() {
        return statersConfigs;
    }

    public PatternMap<RequestInfo, RequestsStater> preparedStaters() {
        return staters;
    }
}

