package ru.yandex.stater;

public class IntegralSumAggregator implements StatsAggregator<Number> {
    private long sum = 0L;

    @Override
    public void accept(final Number value) {
        sum += value.longValue();
    }

    @Override
    public <E extends Exception> void stat(
        final StatsConsumer<? extends E> statsConsumer,
        final String name)
        throws E
    {
        statsConsumer.stat(name, sum);
    }
}

