package ru.yandex.stater;

import ru.yandex.concurrent.LockStorage;

public class LockStorageSizeStater implements Stater {
    private final String signalName;
    private final LockStorage<?, ?> lockStorage;

    public LockStorageSizeStater(
        final String signalName,
        final LockStorage<?, ?> lockStorage)
    {
        this.signalName = signalName;
        this.lockStorage = lockStorage;
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        statsConsumer.stat(signalName, lockStorage.size());
    }
}

