package ru.yandex.stater;

import java.util.concurrent.atomic.LongAdder;

public class LongAdderStater implements Stater {
    private final LongAdder adder = new LongAdder();

    private final String signalName;

    public LongAdderStater(final String signalName) {
        this.signalName = signalName;
    }

    public LongAdder adder() {
        return adder;
    }

    public String signalName() {
        return signalName;
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        statsConsumer.stat(signalName, adder.sum());
    }
}

