package ru.yandex.stater;

public class MaxAggregator implements StatsAggregator<Number> {
    private final long defaultValue;
    private boolean empty = true;
    private long max;

    public MaxAggregator(final long defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public void accept(final Number boxed) {
        long value = boxed.longValue();
        if (empty) {
            empty = false;
            max = value;
        } else if (max < value) {
            max = value;
        }
    }

    @Override
    public <E extends Exception> void stat(
        final StatsConsumer<? extends E> statsConsumer,
        final String name)
        throws E
    {
        long value;
        if (empty) {
            value = defaultValue;
        } else {
            value = max;
        }
        statsConsumer.stat(name, value);
    }
}

