package ru.yandex.stater;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class MetricsFactory {
    private MetricsFactory() {
    }

    public static MetricBuilder create(
        final String name,
        final IniConfig config)
        throws ConfigException
    {
        final MetricBuilder metric;
        if (name.equalsIgnoreCase("httpcodes")) {
            metric = new HttpCodesMetric(config);
        } else if (name.equalsIgnoreCase("requesttimes")) {
            metric = new RequestTimeMetric(config);
        } else if (name.equalsIgnoreCase("requesthist")) {
            metric = new RequestTimeHistogramMetric(config);
        } else {
            throw new ConfigException("Unknown metric: " + name);
        }
        return metric;
    }
}
