package ru.yandex.stater;

public class MinAggregator implements StatsAggregator<Number> {
    private final Long defaultValue;
    private boolean empty = true;
    private long min;

    public MinAggregator() {
        defaultValue = null;
    }

    public MinAggregator(final Long defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public void accept(final Number boxed) {
        long value = boxed.longValue();
        if (empty) {
            empty = false;
            min = value;
        } else if (min > value) {
            min = value;
        }
    }

    @Override
    public <E extends Exception> void stat(
        final StatsConsumer<? extends E> statsConsumer,
        final String name)
        throws E
    {
        long value;
        if (empty) {
            if (defaultValue == null) {
                return;
            }
            value = defaultValue;
        } else {
            value = min;
        }
        statsConsumer.stat(name, value);
    }
}

