package ru.yandex.stater;

public class NamedStatsAggregator<T> implements PassiveStater<T> {
    private final String name;
    private final StatsAggregator<? super T> aggregator;

    public NamedStatsAggregator(
        final String name,
        final StatsAggregator<? super T> aggregator)
    {
        this.name = name;
        this.aggregator = aggregator;
    }

    @Override
    public void accept(final T value) {
        aggregator.accept(value);
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        aggregator.stat(statsConsumer, name);
    }
}

