package ru.yandex.stater;

import java.util.function.Supplier;

public class NamedStatsAggregatorFactory<T>
    implements Supplier<NamedStatsAggregator<T>>
{
    private final String name;
    private final Supplier<? extends StatsAggregator<? super T>>
        aggregatorsFactory;

    public NamedStatsAggregatorFactory(
        final String name,
        final Supplier<? extends StatsAggregator<? super T>>
        aggregatorsFactory)
    {
        this.name = name;
        this.aggregatorsFactory = aggregatorsFactory;
    }

    @Override
    public NamedStatsAggregator<T> get() {
        return new NamedStatsAggregator<>(name, aggregatorsFactory.get());
    }
}

