package ru.yandex.stater;

public class NonEmptyStater implements Stater {
    private final String signalName;
    private final Iterable<?> iterable;

    public NonEmptyStater(
        final String signalName,
        final Iterable<?> iterable)
    {
        this.signalName = signalName;
        this.iterable = iterable;
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        if (iterable.iterator().hasNext()) {
            statsConsumer.stat(signalName, 1);
        } else {
            statsConsumer.stat(signalName, 0);
        }
    }
}

