package ru.yandex.stater;

import java.util.function.Supplier;

public class PassiveStaterAdapter<T> implements Stater {
    private final Iterable<? extends T> data;
    private final Supplier<? extends PassiveStater<? super T>> statersFactory;

    public PassiveStaterAdapter(
        final Iterable<? extends T> data,
        final Supplier<? extends PassiveStater<? super T>> statersFactory)
    {
        this.data = data;
        this.statersFactory = statersFactory;
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        PassiveStater<? super T> stater = statersFactory.get();
        for (T value: data) {
            stater.accept(value);
        }
        stater.stats(statsConsumer);
    }

    @Override
    public void addToGolovanPanel(
        final GolovanPanel panel,
        final String prefix)
    {
        statersFactory.get().addToGolovanPanel(panel, prefix);
    }
}

