package ru.yandex.stater;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.config.IniConfig;

public class PrefixingStater implements Stater {
    private final String prefix;
    private final Stater stater;
    private final boolean keepOriginal;

    public PrefixingStater(final String prefix, final Stater stater) {
        this(prefix, stater, false);
    }

    public PrefixingStater(
        final String prefix,
        final Stater stater,
        final boolean keepOriginal)
    {
        this.prefix = prefix;
        this.stater = stater;
        this.keepOriginal = keepOriginal;
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        stater.stats(
            new PrefixingStatsConsumer<>(statsConsumer, prefix, keepOriginal));
    }

    @Override
    public final void addToGolovanPanel(
        final GolovanPanel panel,
        final String statsPrefix)
    {
        stater.addToGolovanPanel(panel, statsPrefix + prefix);
    }

    @Override
    public void addToAlertsConfig(
        final IniConfig alertsConfig,
        final ImmutableGolovanPanelConfig panelConfig,
        final String statsPrefix)
        throws BadRequestException
    {
        stater.addToAlertsConfig(
            alertsConfig,
            panelConfig,
            statsPrefix + prefix);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder();
        sb.append("PrefixingStater[prefix=");
        sb.append(prefix);
        sb.append(" keepOriginal=");
        sb.append(keepOriginal);
        sb.append(" stater=");
        sb.append(stater);
        sb.append(']');
        return new String(sb);
    }

    private static class PrefixingStatsConsumer<E extends Exception>
        implements StatsConsumer<E>
    {
        private final StatsConsumer<? extends E> statsConsumer;
        private final String prefix;
        private final boolean keepOriginal;

        PrefixingStatsConsumer(
            final StatsConsumer<? extends E> statsConsumer,
            final String prefix,
            final boolean keepOriginal)
        {
            this.statsConsumer = statsConsumer;
            this.prefix = prefix;
            this.keepOriginal = keepOriginal;
        }

        @Override
        public void stat(final String name, final boolean value) throws E {
            if (keepOriginal) {
                statsConsumer.stat(name, value);
            }
            statsConsumer.stat(prefix + name, value);
        }

        @Override
        public void stat(final String name, final long value) throws E {
            if (keepOriginal) {
                statsConsumer.stat(name, value);
            }
            statsConsumer.stat(prefix + name, value);
        }

        @Override
        public void stat(final String name, final double value) throws E {
            if (keepOriginal) {
                statsConsumer.stat(name, value);
            }
            statsConsumer.stat(prefix + name, value);
        }

        @Override
        public void stat(final String name, final long[] value) throws E {
            if (keepOriginal) {
                statsConsumer.stat(name, value);
            }
            statsConsumer.stat(prefix + name, value);
        }
    }
}

