package ru.yandex.stater;

public class RequestInfo {
    private final long endTime;
    private final int httpCode;
    private final long requestLength;
    private final long responseLength;
    private final long requestTime;
    private final long processingTime;

    public RequestInfo(
        final long endTime,
        final int httpCode,
        final long requestStart,
        final long processingStart,
        final long requestLength,
        final long responseLength)
    {
        this.endTime = endTime;
        this.httpCode = httpCode;
        this.requestLength = requestLength;
        this.responseLength = responseLength;
        requestTime = endTime - requestStart;
        processingTime = endTime - processingStart;
    }

    public long endTime() {
        return endTime;
    }

    public int httpCode() {
        return httpCode;
    }

    public long requestLength() {
        return requestLength;
    }

    public long responseLength() {
        return responseLength;
    }

    public long requestTime() {
        return requestTime;
    }

    public long processingTime() {
        return processingTime;
    }
}
