package ru.yandex.stater;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class StaterConfigBuilder
    extends AbstractStaterConfigBuilder<StaterConfigBuilder>
{
    public StaterConfigBuilder() {
        super(StaterConfigDefaults.INSTANCE);
    }

    public StaterConfigBuilder(final StaterConfig config) {
        super(config);
    }

    public StaterConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, StaterConfigDefaults.INSTANCE);
    }

    public StaterConfigBuilder(
        final IniConfig config,
        final StaterConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public StaterConfigBuilder self() {
        return this;
    }

    public ImmutableStaterConfig build() {
        return new ImmutableStaterConfig(this);
    }
}

